/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.entity;

import com.cobblemon.mod.common.Cobblemon;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.advancement.CustomCriteria;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.EntityBackedTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntityPayload;
import kiwiapollo.cobblemontrainerbattle.exception.BattleStartException;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.TrainerRecord;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerStorage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1371;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_8567;
import net.minecraft.class_8710;

public class TrainerEntity
extends class_1314 {
    public static final int FLEE_DISTANCE = 20;
    private String trainer;
    private class_2960 texture;
    private TrainerBattle trainerBattle;

    public TrainerEntity(class_1299<? extends class_1314> type, class_1937 world, String trainer) {
        super(type, world);
        this.trainer = trainer;
        this.texture = TrainerEntity.toTexture(trainer);
        this.trainerBattle = null;
    }

    private static class_2960 toTexture(String trainer) {
        try {
            return TrainerStorage.getInstance().get(trainer).getTexture();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1371((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (!(player instanceof class_3222)) {
            return class_1269.field_5814;
        }
        this.startTrainerBattle((class_3222)player, hand);
        return super.method_5992(player, hand);
    }

    private void startTrainerBattle(class_3222 player, class_1268 hand) {
        try {
            if (this.isTrainerBattleExist()) {
                return;
            }
            EntityBackedTrainerBattle trainerBattle = new EntityBackedTrainerBattle(new PlayerBattleParticipantFactory(player, this.getLevelMode(this.trainer)).create(), new TrainerBattleParticipantFactory(this.trainer).create(), this);
            trainerBattle.start();
            BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setTrainerBattle(trainerBattle);
            this.trainerBattle = trainerBattle;
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5977(true);
            this.field_6007 = true;
            class_174.field_25694.method_30097(player, player.method_5998(hand), (class_1297)this);
        }
        catch (BattleStartException battleStartException) {
            // empty catch block
        }
    }

    private LevelMode getLevelMode(String trainer) {
        return TrainerStorage.getInstance().get(trainer).getLevelMode();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isTrainerBattleExist()) {
            return false;
        }
        boolean isDamaged = super.method_5643(source, amount);
        boolean isLivingEntityAttacker = source.method_5529() instanceof class_1309;
        if (isDamaged && isLivingEntityAttacker && !source.method_5530()) {
            this.method_5980((class_1309)source.method_5529());
        }
        return isDamaged;
    }

    private boolean isTrainerBattleExist() {
        try {
            UUID battleId = this.trainerBattle.getBattleId();
            return Objects.nonNull(Cobblemon.INSTANCE.getBattleRegistry().getBattle(battleId));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void method_6078(class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerHistory history = PlayerHistoryStorage.getInstance().getOrCreate(player.method_5667());
            TrainerRecord record = history.getOrCreate(this.trainer);
            record.setKillCount(record.getKillCount() + 1);
            CustomCriteria.KILL_TRAINER_CRITERION.trigger(player);
        }
        if (this.isTrainerBattleExist()) {
            UUID battleId = this.trainerBattle.getBattleId();
            Cobblemon.INSTANCE.getBattleRegistry().getBattle(battleId).end();
        }
        super.method_6078(damageSource);
    }

    public void onPlayerDefeat() {
        this.method_5977(false);
    }

    public void onPlayerVictory() {
        this.dropDefeatInBattleLoot();
        this.method_31472();
    }

    private void dropDefeatInBattleLoot() {
        class_5321 registryKey = this.method_5989();
        class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(registryKey);
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)this.method_37908().method_48963().method_48830());
        class_8567 lootContextParameterSet = builder.method_51875(class_173.field_1173);
        lootTable.method_51880(lootContextParameterSet, this.method_51851(), arg_0 -> ((TrainerEntity)this).method_5775(arg_0));
    }

    public void synchronizeClient(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new TrainerEntityPayload(this.method_5628(), this.trainer, this.texture));
        }
    }

    public void setTrainer(String trainer) {
        this.trainer = trainer;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Trainer", this.trainer);
        nbt.method_10582("Texture", this.texture.toString());
    }

    public void method_5749(class_2487 nbt) {
        try {
            super.method_5749(nbt);
            this.trainer = nbt.method_10558("Trainer");
            this.texture = class_2960.method_12829((String)nbt.method_10558("Texture"));
        }
        catch (NullPointerException e) {
            this.method_31472();
        }
    }
}

